import Joi from 'joi';
import express from 'express';

import userActivity from '../../service/audit-log';
import { permission } from '../../middlewares/permission'; 
import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    socMail: Joi.array().items(Joi.string().email({ tlds: { allow: false } })).required(),
});

/**
 * @api {post} /api/admin/update-soc-mail Update Soc
 * @apiName update-soc-mail
 * @apiGroup Authentication
 * 
 * @apiBody (login)  {String} Soc Email   Required Soc Mail for the company    
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess (200) {String} success     true
 * @apiSuccess (200) {String} message     Soc Email updated successfully
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message": "Soc Email updated successfully"
 *      }
 * 
 */

let controller = async (req, res, next) => {
	try {
		const { socMail } = req.body;
		await db.Company.findOneAndUpdate({
			_id: req.user.companyId
		}, {
			socEmail: socMail
		}, {
			new: true
		});

		userActivity.create(req, 'Soc Email Update', JSON.stringify(socMail));
        logger.info(`User ${req.user.email} Soc Email Update`, { client: req.user.companyId, request: req, event: 'Soc Email Update' });

		return res.status(200).send({
			success: true,
			message: 'SOC Email updated successfully'
		})
	} catch (err) {
		console.log(err);
		next(err)
	}
}

const apiRouter = express.Router();
apiRouter.route('/').patch(htmlsanitize(), jwtStrategy, validateBody(validator), permission('Users','Write'), controller);
export default apiRouter;