import Joi from 'joi';
import express from 'express';

import userActivity from '../../service/audit-log';
import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
	email: Joi.string().email().required(),
	token: Joi.string().required()
});

/**
 * @api {post} /api/admin/verify-email Verify Email
 * @apiName verify-email
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String}    email     Required email of the User.
 * @apiBody {String}    token     Required token sent in mail
 * 
 * @apiSuccess {Boolean} success-1   true
 * @apiSuccess {String}  message-1   email successfully verified
 * @apiSuccess {Boolean} success-2   true
 * @apiSuccess {String}  message-2   You are Already Verified. You can proceed to login!
 *  
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"email successfully verified"
 *      }
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"You are Already Verified. You can proceed to login!"
 *      }
 *
 * 
 * @apiError (500)  {String} success-1   false
 * @apiError (500)  {Array}  messages-1  not a valid emailId
 * @apiError (500)  {String} success-2   false
 * @apiError (500)  {Array}  messages-2  invalid token
 *
 *
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "not a valid emailId"
 *           ]
 *        }
 *
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
         {
             "success": false,
             "messages": [
                 "invalid token"
             ]
         }
  */

const controller = async (req, res, next) => {
    try {
        const { email, token } = req.body;
        const user = await db.Admin.findOne({
            email
        })
        if(!user){
            throw new RequestError('not a valid emailId');
        }
        if(user.isVerify){
            return res.status(200).json({
                success:true, 
                message: "You are Already Verified. You may proceed to login!"
            })
        }

        if(user.verfKey == token){
            await db.Admin.findOneAndUpdate({
                _id: user._id
            }, {
                verfKey: null,
                isVerify: true,
                isActive: true
            })
        } else {
            throw new RequestError('invalid token or url');
        }

        req['user'] = user;
        userActivity.create(req, 'Verify Email');
        logger.info(`User ${email} Verify Email`, { client: user.companyId, request: req, event: 'Verify Email' });

        return res.status(200).json({ 
            success: true, 
            message: 'email verified successfully'
        })
    } catch (err) {
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').post( htmlsanitize(), validateBody(validator), controller);
export default apiRouter;