import Joi from 'joi';
import express from 'express';
import bcrypt from 'bcryptjs';

import crypto from '../../crypto';
import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    token: Joi.string().required(),
	email: Joi.string().required(),
});

/**
 * @api {post} /api/admin/reset-password Reset Password
 * @apiName reset-password
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} token               Required token sent in mail.
 * @apiBody {String} email               Required email of the user.
 * @apiBody {String} password            Required new password of the User.
 * @apiBody {String} password            Required confirm password of the User.
 *
 * @apiSuccess (200) {String} success     true
 * @apiSuccess (200) {String} Message     Password Updated Successfully!
 * 
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "Message":"Password Updated Successfully!"
 *      }
 * 
 * @apiError (500)  {String} success   false
 * @apiError (500)  {Array}  messages  Invalid emailId or token recieved
 *
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *  {
 *  "success": false,
 *  "messages": [
 *      {
 *          "status": 500,
 *          "errorList": [
 *              "Invalid emailId or token recieved"
 *          ]
 *      }
 *   ]
 *   }
 *
 * 
 * @apiError (500)  {String} status  false
 * @apiError (500)  {String} message password reset link has been expired
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *  {
 *  "success": false,
 *  "messages": [
 *      {
 *          "status": 500,
 *          "errorList": [
 *              "password reset link has been expired"
 *          ]
 *      }
 *   ]
 *   }
 */

let controller = async (req, res, next) => {
      try {     
        const { email, token } = req.body;
        let user = null, type = 'root';
        console.log({email})

        let encryptEmail = await crypto.decrypt(email);
        console.log({encryptEmail})
        encryptEmail = decodeURIComponent(encryptEmail);
        console.log({encryptEmail})

        user = await db.Admin.findOne({ email: encryptEmail, verfKey: token });
        if(!user){
            type = 'employee';
            user = await db.Employee.findOne({ email: encryptEmail, verfKey: token });
        }
        console.log({user})
        if(user && user.verfKeyExpiry && user.verfKeyExpiry.getTime() < new Date().getTime() - (30 * 60 * 1000)){
            return res.status(200).json({ success: true, isTokenValid: false });
        }
        if(!user){
            return res.status(200).json({ success: true, isTokenValid: false });
        }
        
        return res.status(200).json({ success: true, isTokenValid: true });
    } 
    catch (error) {
        console.log(error);
        next(new RequestError(error))
    }
}
const apiRouter = express.Router();
apiRouter.route('/').post( htmlsanitize(), validateBody(validator), controller);
export default apiRouter;