import express from 'express';
import config from '../../config'
import { queue } from '../../kue';
import { syncDomainsFromTa } from '../../service/syncDomains';

//specific group me user daal ra hain

let controller = async (req, res, next) => {
    try{
        let {api_key,groupDetails,userDetails} = req.body;
        console.log("Reached Here New",api_key,groupDetails,userDetails)

        if ( api_key!== config.adminCentral.api_key || !api_key) {
          throw new RequestError('Unauthorized User', 401);
        }
        let companyId=groupDetails.localCompanyId;

        let syncDomains = await syncDomainsFromTa(companyId)

        let group=await db.Group.findOne({
            tacIdentityKey:groupDetails.identityKey
        })
        console.log({group})
        if(group){
          await db.Group.updateOne({
                 _id: group._id
            },{
              $set: {
                  tacIdentityKey:groupDetails.identityKey,
              }
          })
        }
        else throw new RequestError("Group not found!",404)


        
      let syncData = {
        users: userDetails,
        companyId: companyId,
        groupId: group._id,
        lastSyncId: groupDetails?.lastSyncId,
        isLastBatch: true
      }

      queue.create('add-users-tac', {...syncData})
      .priority('normal')
      .removeOnComplete(true)
      .save() 
  
  
        res.status(200).json({
          message:"sucess"
        })
      }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);
  
        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';
  
        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;