import express from 'express';
import config from '../../config'
import { queue } from '../../kue';
import { syncDomainsFromTa } from '../../service/syncDomains';

//ek group me user hain ab dusre group me bhi same user daalna
let controller = async (req, res, next) => {
    try{
        let {api_key,groupDetails,userDetails} = req.body;

        if ( api_key!== config.adminCentral.api_key || !api_key) {
          throw new RequestError('Unauthorized User', 401);
        }

        let companyId=groupDetails.localCompanyId;
        console.log("The company id is",companyId,groupDetails.tacGroupId)

        let syncDomains = await syncDomainsFromTa(companyId)


        let group = await db.Group.findOne({
            tacIdentityKey:groupDetails.identityKey
        })

        if(!group) throw new RequestError("Group not found!")

        if(group){
          await db.Group.updateOne({
                _id: group._id
        },{
              $set: {
                tacIdentityKey: groupDetails.identityKey,
              }
          })
      }
      let syncData = {
          users: userDetails?.map(user => ({email: user?.userEmail, IdentityKey: user?.IdentityKey})),
          companyId,
          groupId: group._id,
          lastSyncId: groupDetails?.lastSyncId,
          isLastBatch: true
        }

        queue.create(`add-users-tac`, {...syncData})
        .priority('normal')
        .removeOnComplete(true)
        .save() 

        res.status(200).json({
          message:"sucess"
        })
      }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);
  
        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';
  
        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;