import express from 'express';
import config from '../../config'
import { queue } from '../../kue';
import { syncDomainsFromTa } from '../../service/syncDomains';

let controller = async (req, res, next) => {
  try {
      const licenseKey = req?.headers?.authorization?.split(' ')[1] ?? null;
      if (!licenseKey) {
          throw new RequestError('License key not received.', 401);
      }
      const company = await db.Company.findOne({
              tacLicenseKey: licenseKey
      });
      if (!(company && company.isTacEnabled)) throw new RequestError('Threatcop Admin is already disconnected.', 400);

      const individualUserGroup = await db.Group.findOne({
        groupName: "Individual-Users",
        type: "Admin",
        companyId: company?._id,
        deletedAt: null
       }) 

       const allUsersGroup = await db.Group.findOne({
        groupName:'all-useres-tpir',
        isDefaultGroup: true,
        companyId: company?._id,
        deletedAt: null
       })

        await db.Group.updateMany(
            { companyId: company._id, type: "Custom", deletedAt: null },
            { $set: { type: "Admin" } }
        );

        if(individualUserGroup){
            await db.User.updateMany({companyId: company._id},
                {
                    $pull: { groups: individualUserGroup._id },
                    $set:{isActive: false, isActiveMessenger: false}
                }
            )

            await db.Group.deleteOne({_id:individualUserGroup._id, companyId: company._id})
        }

        await db.Company.updateOne({ _id: company._id }, { $set: { isTacEnabled: false, isTaConnectionInProgess: false } });


      return res.status(200).json({
          success: 'true',
          message: 'Disconnected successfully.'
      });
      } catch (error) {
          next(error);
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;