import express from 'express';
import config from '../../config'
import { queue } from '../../kue';
import { syncDomainsFromTa } from "../../service/syncDomains"
//ye all-users-tpir group me daalegi users bhejke

let controller = async (req, res, next) => {
    let { api_key, userDetails, localCompanyId, identityKey, lastSyncId } = req.body;
        try {
            console.log("userDetails", userDetails)
            if (api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);
            
            let group = await db.Group.findOne({
                    tacIdentityKey: identityKey
            })
            if(!group){
                group = await db.Group.findOne({
                        groupName: 'Individual-Users',
                        companyId: localCompanyId,
                        tacIdentityKey: identityKey
                });
                if (!group) {
                    group = await db.Group.create({
                        groupName: 'Individual-Users',
                        companyId: localCompanyId,
                        tacIdentityKey: identityKey,
                        type:"Admin"
                    });
                }else{
                    let group = await db.Group.updateOne({
                        _id: group.id
                    }, {
                        $set: {
                            tacIdentityKey: identityKey,
                            type:"Admin"
                        }
                    })
                }
            }

            let syncDomains = await syncDomainsFromTa(localCompanyId)


            let syncData = {
                users: userDetails,
                companyId: localCompanyId,
                groupId: group._id,
                lastSyncId,
                isLastBatch: true
            }

            queue.create(`add-users-tac`, {...syncData})
            .priority('normal')
            .removeOnComplete(true)
            .save()    
            
            return res.status(200).json({
                message: "success",
                data: group.id,
            })


        } catch (error) {
            const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;

            // Log the error internally
            console.error('API Error:', error);

            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ?
                (error.message || "The request could not be processed.") :
                "An internal server error occurred.";

            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;