import express from 'express';
import config from '../../config'
import { queue } from '../../kue';
import { syncDomainsFromTa } from '../../service/syncDomains'

//pehle group banaya aur fir users mangayeee    
let controller = async (req, res, next) => {
    let { api_key, groupDetails, companyId } = req.body;
        if (api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);
        let groupDetailsResponse = [];

        try {
            for (let groupInfo of groupDetails) {
                let Group = await db.Group.findOne({
                        tacIdentityKey: groupInfo.identityKey
                })
                console.log({Group})
                if (!Group) {
                    Group = await db.Group.create({
                        groupName: groupInfo.groupName,
                        companyId: groupInfo.localCompanyId,
                        tacGroupId: groupInfo.tacGroupId,
                        tacIdentityKey: groupInfo.identityKey,
                        isSyncingUsers: true,
                        type:"Admin",
                    })
                }else{
                    Group = await db.Group.updateOne({
                        groupName: groupInfo.groupName,
                        companyId: groupInfo.localCompanyId,
                        tacGroupId: groupInfo.tacGroupId,
                    }, {
                        $set: {
                            tacIdentityKey: groupInfo.identityKey,
                            isSyncingUsers: true,
                            type:"Admin"
                        },
                    })
                }
                groupDetailsResponse.push({
                    localGroupId: Group._id,
                })

            }
            if(groupDetails[0].localCompanyId) await syncDomainsFromTa(groupDetails[0].localCompanyId)

            for (let group of groupDetails) {
                let groupTPIR = await db.Group.findOne({
                        groupName: group.groupName,
                        companyId: group.localCompanyId,
                })
                if (groupTPIR) {
                    queue.create('asssign-group-user',{
                        localGroupId:groupTPIR._id,
                        localCompanyId:group.localCompanyId,
                        tacIdentityKey: group.identityKey,
                        tacCompanyId:companyId,
                        lastSyncId: group?.lastSyncId,
                        memberCount:group.usersCount,
                    }).removeOnComplete(true).save();
                }
            }
            res.status(200).json({
                message: "success",
                data: groupDetailsResponse,
            })

        } catch (error) {
            const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;

            // Log the error internally
            console.error('API Error:', error);

            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ?
                (error.message || "The request could not be processed.") :
                "An internal server error occurred.";

            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;