import express from 'express';
import config from '../../config'
import crypto from '../../crypto';
import sanitizeHtml from 'sanitize-html';
import { randomString } from '../../functions';
import userActivity from '../../service/audit-log';
import bcrypt from 'bcryptjs';

let controller = async (req, res, next) => {
    let { email, firstName, lastName, roleId, api_key, meta, IdentityKey } = req.body;
    const { companyId } = req.params;
    try {
      console.log("api_key",api_key);
      console.log("api_key-env",config.adminCentral.api_key);
      if (api_key !== config.adminCentral.api_key) {
        throw new RequestError('UnAuthorized User', 401);
      }
      if (!companyId) {
        throw new RequestError('UnAuthorized User', 401);
      }

      email = sanitizeHtml(email)
      // firstName = sanitizeHtml(firstName)
      // lastName = sanitizeHtml(lastName)
      //   console.log(email);
      //   console.log(firstName);
      //   console.log(lastName);
      if(!email.length) throw new RequestError("Email is empty after sanitizing!")
      // else if(!firstName.length) throw new RequestError("First Name is empty after sanitizing!")
      //else if (!lastName.length) throw new RequestError("Last Name is empty after sanitizing!")

      // const isHyperLink = /^[a-zA-Z]+$/

      // if(!isHyperLink.test(firstName)) throw new RequestError("First name cannot be a hyperlink!")
      //if(!isHyperLink.test(lastName)) throw new RequestError("Last name cannot be a hyperlink!")

      const verfKey = randomString(10);

      const checkEmployee = await db.Employee.findOne({ 
          email,
          companyId, 
          deletedAt: null
      })
      if (checkEmployee) {
          await db.Employee.updateOne({email, companyId, deletedAt: null},{$set:{tacIdentityKey: IdentityKey}})
          throw new RequestError("Same email already exists please try with another email!");
      }

      let passwordHash = ''
      if (meta) { 
        const decryptedPassword = crypto.decrypt(meta, config.adminCentral.crypto_secret);
        if (!decryptedPassword) {
            throw new RequestError('Request from invalid source, meta decryption failed.', 409);
        }
        console.log({aaaa:decryptedPassword})
        passwordHash = bcrypt.hashSync(decryptedPassword);
      }

      let newEmployee = await db.Employee.create({ 
          email, firstName, lastName, companyId, tacIdentityKey: IdentityKey,  password: passwordHash, isVerify: true, isActive: true
      })
      
      userActivity.create(req, 'Add IAM User', email);

      let EmployeeRole = await db.EmployeeRole.findOne({ employeeId: newEmployee._id, companyId });

      if(!EmployeeRole){
        await db.EmployeeRole.create({
            employeeId: newEmployee._id,
            roleIds: [roleId],
            companyId
          });
      }

      return res.status(200).json({ response: {email , userId : newEmployee._id} });

    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/:companyId').post(controller);
export default apiRouter;