import express from 'express';
import config from '../../config'

let controller = async (req, res, next) => {
    try {
        const { roleName, description , policyIds, companyId } = req.body;
        const api_key= req?.headers?.authorization?.split(' ')[1] ?? null;
        if ( api_key !== config.adminCentral.api_key || !api_key) {
          throw new RequestError('UnAuthorized User', 401);
        }
        else if ( !roleName || !policyIds) throw new RequestError('Invalid Request', 400);
        
        const isExistingRole = await db.Role.findOne({ roleName: roleName.toLowerCase(), companyId });
        if (isExistingRole) {
          throw new RequestError("Role with same name already exists")
        }
       
        let policyIdArr = [];
        for (let i = 0; i < policyIds.length; i++){
          let id  = policyIds[i];
          const Policy = await db.Policy.findById(id);
          if(Policy && Policy._id) policyIdArr.push(Policy._id);
          else continue
        }
    
        const Role = await db.Role.create({
          roleName: roleName.toLowerCase(),
          policyIds: policyIdArr,
          description,
          companyId
        });        
        return res.status(200).json({ success: true, message: `${roleName} created successfully.`})

    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post(controller);
export default apiRouter;