import express from 'express';
import config from '../../config'
import { randomString } from '../../functions';
import bcrypt from 'bcryptjs';
import crypto from '../../crypto'

let controller = async (req, res, next) => {
    try {
        let {firstName , lastName , email , meta  , tacCompanyId , api_key, IdentityKey} = req.body;
        if(api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);

        let decryptPassowrd = crypto.decrypt(meta, config.adminCentral.crypto_secret);
        let password;
        if(!decryptPassowrd){
            throw new RequestError('Request from invalid source, meta decryption failed.',409);
        }else{
            password = decryptPassowrd;
        }
        var passwordHash = bcrypt.hashSync(password);
       
        const alias = randomString(10);
        const verfKey = randomString(10);

        const user = await db.Admin.findOne({ 
            email,
            tacIdentityKey: IdentityKey,
            deletedAt: null
        })
        if(user){
            await db.Admin.updateOne({email, deletedAt: null},{$set:{tacIdentityKey: IdentityKey}})
            throw new RequestError('Email already exists.', 403)
        }

        let company;

        company = await db.Company.findOne({
            tacCompanyId
        })
        if(!company){
            company = await db.Company.create({
                alias,
                tacCompanyId,
            })

            await db.MetaData.create({
                companyId: company._id, 
                name: 'userLimit', 
                value: "10"
            })
            await db.MetaData.create({
                companyId: company._id, 
                name: 'domainLimit', 
                value: "1"
            })
            await db.MetaData.create({
                companyId: company._id, 
                name: 'expiredAt', 
                value:  new Date(new Date(company.createdAt).setDate(new Date(company.createdAt).getDate()+14))
            })
            await db.MetaData.create({
                companyId: company._id, 
                name:'tsatUrl',
                value:`${config.app.tsatUrl}`
            })
            await db.MetaData.create({
                companyId: company._id, 
                name:'isTsat',
                value:"false"
            })
            await db.MetaData.create({
                companyId: company._id, 
                name:'mailSmtp',
                value: false
            })
    
            await db.MetaData.create({
                companyId: company._id,
                name:'userLimitMessenger',
                value:'0'
            })
     
        }

        const admin = await db.Admin.create({
            firstName, lastName, email, 
            password: passwordHash, 
            companyId: company._id, verfKey,
            tacIdentityKey: IdentityKey,
            isActive: true, isVerify: true
        })


        return res.status(200).json({ 
            success : "true",
            message : "user created in TPIR",
            response : email,
        });
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;