import express from 'express';
import config from '../../config'
import { queue } from '../../kue';


let controller = async (req, res, next) => {
        try {
            const { userId, companyId } = req.body;
            const api_key= req?.headers?.authorization?.split(' ')[1] ?? null;
            if (!api_key || api_key !== config.adminCentral.api_key) {
              throw new RequestError('UnAuthorized User', 401);
            }
            let isEmployeeExists = await db.Employee.findOne({
                    _id: userId,
                    companyId
            });

            if(!isEmployeeExists) throw new RequestError("User doesn't exists, hence can't be deleted", 404);
            await db.Employee.deleteOne({
                    id: userId,
                    companyId
            });
            await db.EmployeeRole.deleteOne({
                employeeId: userId,
                companyId
            });

            return res.status(200).json({ success: true, message: `User deleted successfully.`})
      
          } catch (error) {
               const statusCode = error.status || 500;
              const isClientError = statusCode >= 400 && statusCode < 500;
              console.error('API Error:', error);
  
              const responseMessage = isClientError
                  ? error.message || 'The request could not be processed.'
                  : 'An internal server error occurred.';
  
              res.status(statusCode).json({
                  success: false,
                  message: responseMessage,
                  error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
              });
          }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;