import express from 'express';
import config from '../../config'
import { queue } from '../../kue';


let controller = async (req, res, next) => {
    try {
        const { roleId, companyId } = req.body;
        const api_key= req?.headers?.authorization?.split(' ')[1] ?? null;
        if (!api_key || api_key !== config.adminCentral.api_key) {
          throw new RequestError('UnAuthorized User', 401);
        }

        let isRoleExists = await db.Role.findOne({
                _id: roleId,
                deletedAt: null
        });

        if(isRoleExists && isRoleExists.roleType == 'Default') throw new RequestError("Default role can't be deleted!", 404);
        if(!isRoleExists) throw new RequestError("Role doesn't exists, hence can't be deleted", 404);
        if(isRoleExists && isRoleExists.roleType == "Default") throw new RequestError("Default Roles cannot be deleted!",403);
        
        const employeeRoles = await db.EmployeeRole.find({ companyId });
        
        for (const employeeRole of employeeRoles) {
            if (employeeRole && employeeRole.roleIds && employeeRole.roleIds.length) {
                let newValueArr = employeeRole.roleIds.filter(val => {
                    return val !== isRoleExists._id;
                });
                await db.EmployeeRole.updateOne({ _id: employeeRole._id }, { $set: { roleIds: newValueArr } });
              }
        }

        await db.Role.deleteOne({ _id: isRoleExists._id });

        return res.status(200).json({ success: true, message: `Role deleted successfully.`})
  
      } catch (error) {
          const statusCode = error.status || 500;
          const isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', error);

          const responseMessage = isClientError
              ? error.message || 'The request could not be processed.'
              : 'An internal server error occurred.';

          res.status(statusCode).json({
              success: false,
              message: responseMessage,
              error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
          });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;