import express from 'express';
import config from '../../config'


let controller = async (req, res, next) => {
    try {
        const api_key = req?.headers?.authorization?.split(' ')[1] ?? null;
        if (!api_key || api_key !== config.adminCentral.api_key) {
            throw new RequestError('Unauthorized User', 401);
        }

        const { roleId, roleName, description = "", policyIds, companyId } = req.body;
        if (!roleName || !Array.isArray(policyIds)) throw new RequestError('Invalid Request', 400);

        const fetchRole = await db.Role.findOne({ _id: roleId, companyId });
        if (!fetchRole) throw new RequestError("Invalid Role ID or Company ID mismatch", 400);

        await db.Role.updateOne({ _id: roleId, companyId }, {$set: { name: roleName, description, policyIds }});

        return res.status(200).json({ success: true, message: `${roleName} updated successfully.` });  
      } catch (error) {
          const statusCode = error.status || 500;
          const isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', error);

          const responseMessage = isClientError
              ? error.message || 'The request could not be processed.'
              : 'An internal server error occurred.';

          res.status(statusCode).json({
              success: false,
              message: responseMessage,
              error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
          });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').post(controller);
export default apiRouter;