import express from 'express';
import config from '../../config'

let controller = async (req, res, next) => {
    try {
        let {domainName , api_key} = req.body;
        if(api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);
        const admins = await db.Admin.find({ 
            email: { $regex: new RegExp(`@${domainName}$`, 'i') },
            deletedAt: null
        }, 'email');
        res.status(200).json({
            "success" : true,
            "message" : "All admins",
            "response" : {olAccountExist : admins.length > 0 ? true : false ,  admins}
        })
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;