import express from 'express';
import config from '../../config'

let controller = async (req, res, next) => {
    try {
        let { companyId, limit = 100, offset = 0, api_key } = req.body;
        console.log("req.bodyyyyyy",req.body)
        if (api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);
        limit = parseInt(limit, 10) || 100; // Default limit to 100 if undefined or invalid
        offset = parseInt(offset, 10) || 0;  // Default offset to 0 if undefined or invalid

        let groups = await db.Group.find({ companyId, isDefaultGroup: false })
        .skip(offset)
        .limit(limit)

        console.log({grorurooriotjoirt: groups})

        let transformedGroups = groups.map((group)=>({
            id: group._id,
            name: group.groupName
        }))


        res.status(200).json({
            success: "true",
            response: transformedGroups
        });
    } catch (error) {
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
        const isClientError = statusCode >= 400 && statusCode < 500;

        // Log the error internally
        console.error('API Error:', error);

        // Respond with a generic error message for server errors to avoid exposing details
        const responseMessage = isClientError ?
            (error.message || "The request could not be processed.") :
            "An internal server error occurred.";

        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
                code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                description: error.description || null // Optional additional info
            } : undefined
        });
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').post(controller);
export default apiRouter;