import express from 'express';
import config from '../../config'

let controller = async (req, res, next) => {
    try {
        let {companyId , api_key} = req.body;
        if(api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);

        let employees = await db.Employee.find({ 
            companyId,
            deletedAt: null
        },{
            '_id': 1,
            'companyId': 1,
            'firstName':1,
            'lastName':1,
            'email':1,
        })
        
        // Transform the result to rename _id to localMongoUserId
        const transformedEmployee = await Promise.all(employees.map(async (employee) => {
            const employeeRoles = await db.EmployeeRole.findOne({ employeeId: employee._id, companyId: employee.companyId }).lean();
            let roleNames = [];
            if (employeeRoles && employeeRoles.roleIds && employeeRoles.roleIds.length > 0) {
                const roles = await db.Role.find({ _id: { $in: employeeRoles.roleIds } }, { roleName: 1 }).lean();
                roleNames = roles.map(role => role.roleName);
            }
            
            return {
                localMongoUserId: employee._id,
                localCompanyId: employee.companyId,
                firstName : employee.firstName,
                lastName : employee.lastName,
                email : employee.email,
                roles: roleNames,
            };
        }));
        
        return res.status(201).json({
            success : true,
            message : "all-users-tpir",
            response : {users : transformedEmployee},
        })
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;