import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy'
import axios from 'axios'
import config from '../../config'

let controller = async (req, res, next) => {
    try{
        const { companyId } = req.user

        const company = await db.Company.findOne({_id: companyId, deletedAt: null})
        if(!company) throw new RequestError("Company not found",404)
        
        if(company.isTaConnectionInProgess || !company.isTacEnabled) return res.status(200).send({success: true, message:"TA Connection in progress or tac not enabled!"})
            
        const groupsFromDb = await db.Group.find({ companyId, isDefaultGroup: false, deletedAt: null }).lean();
        const groupMap = {};

        for (const group of groupsFromDb) {
            const userCount = await db.User.countDocuments({ groups: {$in: [group._id]}, deletedAt: null });

            groupMap[group.tacIdentityKey] = {
                ...group,
                userCount, 
            };
        }


        let apiResponse =await axios.get(`${process.env.TAC_URL}/api/sync-services/common/fetch-group-user-count`,
        {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${company.tacLicenseKey}`
            },
            ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
        }
        )

        const apiGroups = apiResponse?.data?.response?.groupUserCount;
        console.log({resultTACCCC: apiResponse.data})

        let groupIds = []
        let showRetry = apiResponse?.data?.response?.showRetry
        for (const apiGroup of apiGroups) {
            const { groupIdentityKey, userCount: apiUserCount, lastSyncId } = apiGroup;

            const dbGroup = groupMap[groupIdentityKey];
            console.log({dbGroup, apiGroup, condition:{1: dbGroup?.lastSyncId !== lastSyncId, 2:dbGroup?.userCount !== apiUserCount}})

            if (dbGroup) {
                const isMismatch = dbGroup.lastSyncId !== lastSyncId || dbGroup.userCount !== apiUserCount;

                if (isMismatch) {
                    await db.Group.updateOne(
                        { _id: dbGroup._id },
                        { lastSyncIdMismatch: true,
                          groupName: apiGroup?.groupName,
                        }
                    );
                }
                else{
                    await db.Group.updateOne(
                        { _id: dbGroup._id },
                        { lastSyncIdMismatch: false,
                          groupName: apiGroup?.groupName,
                        }
                    );
                }
                groupIds.push(dbGroup._id)
            }
            else{
                let group = await db.Group.create({
                    groupName: apiGroup?.groupName,
                    tacIdentityKey: apiGroup?.groupIdentityKey,
                    type: "Admin",
                    companyId,
                    lastSyncId: null,
                    lastSyncIdMismatch: true,
                })

                groupIds.push(group._id)
            }

        }

        const allUsersGroup = await db.Group.findOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null})

        //Removing admin groups not present in TA
        const removedGroups = await db.Group.find(
            { _id: { $nin: groupIds }, type: "Admin", companyId, isDefaultGroup: false },
            { _id: 1 }
        );

        const removedGroupIds = removedGroups.map(g => g._id);

        await db.Group.deleteMany({ _id: { $in: removedGroupIds } });

        //Disassociating the removed groups from users
        await db.User.updateMany(
            { groups: { $in: removedGroupIds } },
            { $pull: { groups: { $in: removedGroupIds } } }
        );

        console.log("DELTETETETET KRA KRA",removedGroupIds)

        //removing users with only all-users-tpir group and currentGroup
        await db.User.deleteMany({
            groups: { $all: [allUsersGroup._id], $size: 1 },
            companyId
        });


        return res.status(200).send({
            success: true,
            showRetry
        })
      }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);
  
        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';
  
        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').get( jwtStrategy, controller);
export default apiRouter;