import express from 'express';
import config from '../../config'

let controller = async (req, res, next) => {
    try {
        let {companyId , tacGroupId, limit = 100, offset = 10,  groupId , api_key} = req.body;
        if(api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);

        limit = parseInt(limit, 10) || 100; // Default limit to 100 if undefined or invalid
        offset = parseInt(offset, 10) || 0;  // Default offset to 0 if undefined or invalid
        
        const groupMembers = await db.User.find({
            groups: {$in: [groupId]}
        })
        .skip(offset)
        .limit(limit)
        .select('_id name email phoneNumber')

        const transformedGroupMembers = groupMembers.map((member)=>({
            Member:{
                id: member._id,
                firstName: member?.name?.split(" ")[0],
                lastName: member?.name?.split(" ")[1] ? member?.name?.split(" ")[1] : '',
                email: member?.email,
                phoneNumber: member?.phoneNumber 
            }
        }))
        

        if(offset <= 1){
            await db.Group.updateOne({
                groupId
            },{
                $set:{
                    tacGroupId, type: "Admin"
                }
            })
        }
        
        return res.status(201).json({
            success : true,
            message : "all-users-tpir",
            response :  transformedGroupMembers,
        })
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;