import express from "express";
import config from "../../config";
import crypto from "../../crypto";

let controller = async (req, res, next) => {
  let { api_key, limit = 100, offset = 0, search="", roleId="" } = req.query;
  console.log("------", req.query);
  const { companyId } = req.params;
  limit = parseInt(limit, 10) || 100; // Default limit to 100 if undefined or invalid
  offset = parseInt(offset, 10) || 0; // Default offset to 0 if undefined or invalid
  try {
    api_key = crypto.decrypt(
        decodeURIComponent(api_key),
        config.adminCentral.crypto_secret
    );

    if (api_key !== config.adminCentral.api_key) {
      throw new RequestError('UnAuthorized User', 401);
    }
    if (!companyId) {
      throw new RequestError("UnAuthorized User", 401);
    }

    let condition = {
      companyId,
      deletedAt: null,
    };

    if (search && search.length) {
      const regex = new RegExp(search, "i");
      condition["$or"] = [
        { firstName: regex },
        { lastName: regex },
        { email: regex },
      ];
    }
    if(!roleId){
        const employees = await db.Employee.find(condition)
        .skip(offset)
        .limit(limit);
      const employeeIds = employees.map((emp) => emp._id);
      const employeeRoles = await db.EmployeeRole.find({
        companyId,
        employeeId: { $in: employeeIds }, // Filter by the employee IDs
        deletedAt: null,
      }).populate({
        path: "employeeId",
        select: "firstName lastName email isActive isVerify createdAt", // Populate relevant fields
      });
      let details = [];
      for (const val of employeeRoles) {
        let obj = {};
        obj["id"] = val["employeeId"]["_id"];
        obj["firstName"] = val["employeeId"]["firstName"];
        obj["lastName"] = val["employeeId"]["lastName"];
        obj["email"] = val["employeeId"]["email"];
        obj["createdAt"] = val["employeeId"]["createdAt"];
        obj["type"] = "employee";
        obj["roleName"] = [];
        for (const roleId of val.roleIds) {
          if(roleId.length){
            let roleDetails = await db.Role.findOne({ _id: roleId });
            if (roleDetails) obj["roleName"].push(roleDetails.roleName);
          }

        }
        details.push(obj);
      }
      let count = await db.Employee.countDocuments(condition);
      return res.status(200).json({
        response: {
          details,
          count,
        },
      });
    }
    const employees = await db.Employee.find(condition)
      .skip(offset)
      .limit(limit);
    const employeeIds = employees.map((emp) => emp._id);
    

    const employeeRoles = await db.EmployeeRole.find({
      companyId,
      employeeId: { $in: employeeIds }, // Filter by the employee IDs
      roleId: {$in: [roleId]},
      deletedAt: null,
    }).populate({
      path: "employeeId",
      select: "firstName lastName email isActive isVerify createdAt", // Populate relevant fields
    });
    let details = [];
    for (const val of employeeRoles) {
      let obj = {};
      obj["id"] = val["employeeId"]["_id"];
      obj["firstName"] = val["employeeId"]["firstName"];
      obj["lastName"] = val["employeeId"]["lastName"];
      obj["email"] = val["employeeId"]["email"];
      obj["createdAt"] = val["employeeId"]["createdAt"];
      obj["type"] = "employee";
      obj["roleName"] = [];
      for (const roleId of val.roleIds) {
        let roleDetails = await db.Role.findOne({ _id: roleId });
        if (roleDetails) obj["roleName"].push(roleDetails.roleName);

      }
      details.push(obj);
    }
    let count = await db.Employee.countDocuments(condition);
    // return res.status(200).json({ response: employeeRoles });
    return res.status(200).json({
      response: {
        details,
        count,
      },
    });
  } catch (error) {
    const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
    const isClientError = statusCode >= 400 && statusCode < 500;

    // Log the error internally
    console.error("API Error:", error);

    // Respond with a generic error message for server errors to avoid exposing details
    const responseMessage = isClientError
      ? error.message || "The request could not be processed."
      : "An internal server error occurred.";

    res.status(statusCode).json({
      success: false,
      message: responseMessage,
      // Include more specific error details only if it's safe to expose them
      error: isClientError
        ? {
            code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
            description: error.description || null, // Optional additional info
          }
        : undefined,
    });
  }
};
const apiRouter = express.Router();
apiRouter.route("/:companyId").get(controller);
export default apiRouter;
