import express from 'express';
import config from '../../config'
import crypto from '../../crypto';

let controller = async (req, res, next) => {
    let { api_key } = req.query;
    const { companyId } = req.params;
    try {
      api_key = crypto.decrypt(
          decodeURIComponent(api_key),
          config.adminCentral.crypto_secret
      );
      
      if (api_key !== config.adminCentral.api_key) {
        throw new RequestError('UnAuthorized User', 401);
      }
      if (!companyId) {
        throw new RequestError('UnAuthorized User', 401);
      }

      const policies = await db.Policy.find().lean();
      const updatedPolicies = policies.map(policy => ({
      ...policy,
      id: policy._id
      }));

      return res.status(200).json({ response: updatedPolicies });

    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/:companyId').get(controller);
export default apiRouter;