import express from 'express';
import config from '../../config'
import crypto from '../../crypto';

let controller = async (req, res, next) => {
    let { api_key, search="" } = req.query;
    const { companyId } = req.params;
    try {
      api_key = crypto.decrypt(
          decodeURIComponent(api_key),
          config.adminCentral.crypto_secret
      );
      
      if (api_key !== config.adminCentral.api_key) {
        throw new RequestError('UnAuthorized User', 401);
      }
      if (!companyId) {
        throw new RequestError('UnAuthorized User', 401);
      }
      let condition = {
        companyId: companyId
      }
      let conditionForDefaultRoles = {
        roleType:"Default"
      }
      if (search && search.length) {
        const regex = new RegExp(search, "i");
        condition["$or"] = [
          { roleName: regex },
        ];
        conditionForDefaultRoles["$or"] = [
          { roleName: regex },
        ];

      }
        let roles = await db.Role.find(condition).select('roleName description');
        let count = await db.Role.countDocuments(condition)
      let defaultRoles = await db.Role.find(conditionForDefaultRoles);
      roles = [...roles, ...defaultRoles]
      let details = [];
      roles.forEach((val) => {
        let obj = {};
        obj["id"] = val._id;
        obj["name"] = val.roleName;
        obj["description"] = val.description;
        details.push(obj);
      })
      return res.status(200).json({ response: {details,count:count+defaultRoles.length} });
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/:companyId').get(controller);
export default apiRouter;