import express from 'express';
import config from '../../config'

let controller = async (req, res, next) => {
    try {
        let {email, tacCompanyId, api_key, type="root", licenseKey } = req.body;
        if(api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);

        const company = await db.Company.findOne({ 
            tacLicenseKey: licenseKey,
            deletedAt: null
        })
        if(!company) throw new RequestError('company not found!', 404);

        let user = null
        if(type == "root"){
            user = await db.Admin.findOne({ 
                email,
                companyId: company._id,
                isActive: true,
                isVerify: true,
                deletedAt: null
            })
        }
        else{
            user = await db.Employee.findOne({ 
                email,
                companyId: company._id,
                isActive: true,
                isVerify: true,
                deletedAt: null
            })
        }
        if(!user){
            throw new RequestError("User not found", 404);
        }
        
        const transformedUser = {
            localMongoUserId: user._id,
            companyId: user.companyId
        };
        

        console.log({user,company})
         // Transform the result to rename _id to localMongoUserId
         const transformedCompany ={
            localMongoCompanyId: company._id,
            localAlias: company.alias,
            logoPath: `${config.app.url}/api/static/logo/${company.logo}`
        }
       
        await db.Company.updateOne(
            { _id: user.companyId },
            { $set: { tacCompanyId: tacCompanyId } }
          );
        
          console.log("fetch user - details se", transformedUser , transformedCompany)
        res.status(200).json({
            "success" : true,
            "message" : "All admins",
            "response" : {user : transformedUser , company : transformedCompany}
        })
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;