import express from 'express';
import config from '../../config'

const getVerifiedDomains = async (companyId) => {
    try {
        const domains = await db.Domain.find({ isVerified: true, companyId, deletedAt: null }).lean();

        if (!domains.length) {
            return [];
        }

        const results = await Promise.all(domains.map(async (domain) => {
            const subdomains = await db.SubDomainGroup.find({ domainId: domain._id, companyId, deletedAt: null }).lean();
            console.log({subdomains})
            return {
                name: domain.domainName,
                txt: domain.txtRecord,
                type: domain.domainType === "Gsuite"
                    ? "Google Workspace"
                    : domain.domainTypeForOutlook === "EXCHANGE"
                        ? "Microsoft Outlook (Exchange)"
                        : "Microsoft Outlook (O365)",
                subDomains: subdomains.map(sub => sub.groupName) 
            };
        }));

        return results;
    } catch (error) {
        console.error('Error fetching verified domains:', error);
        return []; 
    }
};


let controller = async (req, res, next) => {
    try {
            const api_key= req?.headers?.authorization?.split(' ')[1] ?? null;
            if (!api_key || api_key !== config.adminCentral.api_key) {
                throw new RequestError('UnAuthorized User', 401);
            }
            let {licenseKey} = req.query;
            let company = await db.Company.findOne({
                tacLicenseKey: licenseKey
            })

            if(!company) throw new RequestError("Invalid License Key", 400);
            
            let verifiedDomains = await getVerifiedDomains(company._id)
            console.log({verifiedDomains})

            return res.status(200).json({
                success: true,
                message: "Verified domains list",
                response: {verifiedDomains}
            })
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').get( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;