import express from 'express';
import config from '../../config'
import { queue } from '../../kue';


let controller = async (req, res, next) => {
    try{
        const licenseKey= req?.headers?.authorization?.split(' ')[1] ?? null;

        const company = await db.Company.findOne({tacLicenseKey: licenseKey, deletedAt:null})
        if(!company) throw new RequestError("Company not found!")
        
        const metaData = await db.MetaData.find({
            companyId: company._id,
            deletedAt: null
        })
        
        let groupsWithEmailAccess = await db.Group.find({companyId: company._id, emailAccess: true, deletedAt: null})
        groupsWithEmailAccess = groupsWithEmailAccess.map(group => group._id)
        
        let exhaustedEmailUsersCount = await db.User.countDocuments({companyId: company._id, groups:{$in: groupsWithEmailAccess}, deletedAt: null})
        
        let groupsWithMessengerAccess = await db.Group.find({companyId: company._id, messengerAccess: true, deletedAt: null})
        groupsWithMessengerAccess = groupsWithMessengerAccess.map(group => group._id)

        let exhaustedWhatsappUsersCount = await db.User.countDocuments({companyId: company._id, groups:{$in: groupsWithMessengerAccess}, deletedAt: null})


        return res.status(200).json({
            success: true,
            exhaustedEmailUsersCount,
            exhaustedWhatsappUsersCount
        })
    }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);

        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';

        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').get(controller);
export default apiRouter;