import express from 'express';
import config from '../../config'
import getGraphData from '../../service/dashboardHelper';

const graphFilters = {
  RETPIR1: ['dateTime'],
  RETPIR2: ['dateTime'],
  RETPIR3: ['dateTime'],
  RETPIR4: ['dateTime'],
  RETPIR5: ['dateTime'],
  RETPIR6: ['dateTime']
}

let controller = async (req, res, next) => {
    try {
        const { reportKey } = req.query

        const api_key= req?.headers?.authorization?.split(' ')[1] ?? null;
        if(api_key !== config.adminCentral.api_key) throw new RequestError('UnAuthorized User', 401);
        
        let filter = graphFilters[reportKey]
        
        res.status(200).json({
            "success" : true,
            "response" : filter
        })
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;
        
            // Log the error internally
            console.error('API Error:', error);
        
            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";
        
            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').get( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;