import express from 'express';
import config from '../../config'

async function getRoleWithPolicies(roleId, companyId) {
  try {
    const allPolicies = await db.Policy.find();

    const role = await db.Role.findOne({ _id: roleId }).populate("policyIds");

    if (!role) {
      throw new Error("Role not found");
    }

    const rolePolicyIds = new Set(role?.policyIds.map(policy => policy._id.toString()));

    const policiesArray = allPolicies.map(policy => ({
      id: policy._id,
      name: policy.name,
      isTrue: rolePolicyIds.has(policy._id.toString())
    }));

    const roleResult = {
      id: role._id,
      name: role.roleName,
      description: role.description,
      companyId: role.companyId,
      type: role.roleType,
      policies: policiesArray
    };

    return roleResult;
  } catch (error) {
    console.error(error);
  }
}



let controller = async (req, res, next) => {
    try {
           const api_key = req?.headers?.authorization?.split(' ')[1] ?? null;
           if ( api_key!== config.adminCentral.api_key || !api_key) {
            throw new RequestError('Unauthorized User', 401);
          }

            let { roleId } = req.query;
            let { companyId } = req.params;

            console.log({roleId, companyId})
    
            if (!roleId) {
                throw new RequestError('Role ID is required.', 400);
            }
    
            let role = await db.Role.findOne({
                 _id: roleId
            }).populate("policyIds");

    
            if (!role) {
                throw new RequestError('Role not found.', 404);
            }

            const roleWithPolicies = await getRoleWithPolicies(roleId, companyId)
    
            return res.status(200).json({
                success: true,
                data: roleWithPolicies
            });
    
      } catch (error) {
          const statusCode = error.status || 500;
          const isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', error);

          const responseMessage = isClientError
              ? error.message || 'The request could not be processed.'
              : 'An internal server error occurred.';

          res.status(statusCode).json({
              success: false,
              message: responseMessage,
              error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
          });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/:companyId').get(controller);
export default apiRouter;