import express from 'express';
import axios from 'axios';
import config from '../../config'
import { queue } from '../../kue';


let controller = async (req, res, next) => {
    try{
        let {companyId} = req.user;
        let appName = "TPIR";
        let { page=1, limit=10, search="" } = req.query;
        limit = limit ? parseInt(limit, 10) : 10;
        const offset = page ? (parseInt(page, 10) - 1) * limit : 0;
        const company = await db.Company.findOne({
                _id: companyId
        })
        const response = await axios.get(
            `${process.env.TAC_URL}/api/sync-services/common/list-tac-group`, 
            {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${config.adminCentral.api_key}`
                },
                params: {
                    companyId: company.tacCompanyId,
                    offset,
                    limit,
                    appName,
                    search, 
                },
                ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            }
        );
        
        return res.status(200).json({
            success: true,
            message: "Group list retrieved successfully",
            response: response.data.response
        })
        
    }catch(error){
        const statusCode = error.status || 500;
      const isClientError = statusCode >= 400 && statusCode < 500;
      console.error('API Error:', error);

      const responseMessage = isClientError
          ? error.message || 'The request could not be processed.'
          : 'An internal server error occurred.';

      res.status(statusCode).json({
          success: false,
          message: responseMessage,
          error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
      });
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;