import express from 'express';
import config from '../../config'
import { queue } from '../../kue';


let controller = async (req, res, next) => {
    try{
        const { api_key, groupDetails, localCompanyId, userToDeleteDetails } = req.body;
        console.log("Received data:", req.body);

        if (api_key !== config.adminCentral.api_key || !api_key) {
            throw new RequestError('Unauthorized User', 401);
        }

        console.log("Processing group deletions", groupDetails);

        const groupIds = groupDetails.map(groupDetail => groupDetail.identityKey);

        const groups = await db.Group.find({ tacIdentityKey: { $in: groupIds }, companyId: localCompanyId });
        const groupObjectIds = groups.map(group => group._id);
        
        await db.User.updateMany(
            { companyId: localCompanyId, groups: { $in: groupObjectIds } },
            { $pull: { groups: { $in: groupObjectIds } } }
        );
        
        await db.User.deleteMany({
            companyId: localCompanyId,
            groups: { $size: 1 },
            deletedAt: null,
        });
        
        await db.Group.deleteMany({ _id: { $in: groupObjectIds }, companyId: localCompanyId, isDefaultGroup: false });

        if (Array.isArray(userToDeleteDetails) && userToDeleteDetails.length > 0) {
            const identityKeys = userToDeleteDetails
              .map(user => user.IdentityKey)
              .filter(Boolean);
      
            if (identityKeys.length > 0) {
              await db.User.deleteMany({
                tacIdentityKey: { $in: identityKeys },
                companyId: localCompanyId,
                deletedAt: null
              });
            }
          }      

        return res.status(200).json({
            success: true,
            message: `Groups deleted successfully.`
        }); 
    }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);

        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';

        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;