import express from 'express';
import config from '../../config'
import { queue } from '../../kue';


let controller = async (req, res, next) => {
    try{
      const { api_key, groupDetails, userDetails, lastSyncId, willGroupDelete, removeUserFromApplicationDetails } = req.body;

      if (!api_key || api_key !== config.adminCentral.api_key) {
        throw new RequestError('Unauthorized User', 401);
      }
      
      const companyId = groupDetails.localCompanyId;
      
      const group = await db.Group.findOne({
        tacIdentityKey: groupDetails.identityKey,
        companyId,
      });

      console.log({group})
      
      if (!group) throw new RequestError("Group not found!");

      
      const allUsersGroup = await db.Group.findOne({
        groupName: "all-users-tpir",
        isDefaultGroup: true,
        companyId,
      }).select('_id');

      console.log({allUsersGroup})
      
      for (const user of userDetails) {
        let usr = await db.User.findOne({ 
           tacIdentityKey: user.IdentityKey,
           email: user.userEmail,
           companyId 
        });
        console.log({usr})
      
        if (usr) {
          const updatedUser = await db.User.findByIdAndUpdate(
            usr._id,
            { $pull: { groups: group._id } },
          );
          console.log({updatedUser})

          if (
            updatedUser.groups.length === 1 &&
            updatedUser.groups.includes(allUsersGroup._id)
          ) {
            await db.User.deleteOne({ _id: updatedUser._id, companyId });
          }
        }
      }

      const updatedUserCountInGroup = await db.User.countDocuments({companyId, groups: {$in: [group._id]}})

      if(updatedUserCountInGroup){
        await db.Group.updateOne(
          { _id: group._id, companyId },
          { $set: { tacIdentityKey: groupDetails.identityKey, lastSyncId: groupDetails.lastSyncId } }
        );
      }
      else if(!updatedUserCountInGroup && willGroupDelete) await db.Group.deleteOne({companyId, _id: group._id})

      if(removeUserFromApplicationDetails && removeUserFromApplicationDetails.length){
        await db.User.deleteMany(
          { tacIdentityKey: { $in: removeUserFromApplicationDetails.map(user => user.IdentityKey) }, companyId }
        );
      }
      
      return res.status(200).json({ message: "done" });

      }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);
  
        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';
  
        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;