import express from 'express';
import config from '../../config'
import { queue } from '../../kue';


let controller = async (req, res, next) => {
    try{
        let { identityKeys, api_key, lastSyncId } = req.body;

        if (!api_key || api_key !== config.adminCentral.api_key) {
            throw new RequestError('Unauthorized User', 401);
        }

        let users = await db.User.find(
            { tacIdentityKey: { $in: identityKeys } },
            { _id: 1, groups: 1 } 
        );

        if (!users.length) {
            return res.status(404).json({ message: "No users found" });
        }

        let groupIds = [...new Set(users.flatMap(user => user.groups))];
        console.log({groupIds})

        let userIds = users.map(user => user._id);

        await db.User.deleteMany({ _id: { $in: userIds } });

        if (groupIds.length) {
            await db.Group.updateMany(
                { _id: { $in: groupIds } },
                { $set: { lastSyncId } }
            );
        }

        return res.status(200).json({
            message: "Users deleted successfully"
        });
        
    }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);

        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';

        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;