import express from 'express';
import axios from 'axios';
import { jwtStrategy } from '../../middlewares/strategy';
import { queue } from '../../kue';
import { syncDomainsFromTa } from '../../service/syncDomains';
import config from '../../config';

const syncGroupUsers = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;

        const company = await db.Company.findOne({ _id: companyId, deletedAt: null });
        if (!company) throw new RequestError("Company not found", 404);

        let syncDomains = await syncDomainsFromTa(company._id)
//who-else check
        const groupsFromDb = await db.Group.find({ companyId, isDefaultGroup:false, deletedAt: null, type:"Admin", lastSyncIdMismatch: true }).lean();
        
        const groupMap = {};
        const mismatchedGroups = []; 
       
        for (const group of groupsFromDb) {
            const userCount = await db.User.countDocuments({ groups: {$in: [group._id]}, deletedAt: null });
            groupMap[group.tacIdentityKey] = {
                ...group,
                userCount
            };
        }

        const apiResponse = await axios.get(
            `${process.env.TAC_URL}/api/sync-services/common/fetch-group-user-count`,
            {
                headers: {
                    "Content-Type": "application/json",
                    Authorization: `Bearer ${company.tacLicenseKey}`,
                },
                ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            }
        );

        const apiGroups = apiResponse?.data?.response?.groupUserCount;

        for (const apiGroup of apiGroups) {
            const { groupIdentityKey, userCount: apiUserCount, lastSyncId } = apiGroup;

            const dbGroup = groupMap[groupIdentityKey];

            if (dbGroup) {
                const isMismatch = dbGroup.lastSyncId !== lastSyncId ||  dbGroup.userCount !== apiUserCount;
                console.log({
                    dbGroup, lastSyncId
                })

                if (isMismatch) {
                    mismatchedGroups.push({
                        ...dbGroup,
                        lastSyncId,
                        apiUserCount
                    });
                }
            }
        }

        const allUsersGroup = await db.Group.findOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null})

        console.log({mismatchedGroups})

        for (let i=0; i<mismatchedGroups.length; i++) {
            let group = mismatchedGroups[i]
            console.log({group})
            let groupTPIR = await db.Group.findOneAndUpdate({
                    groupName: group.groupName,
                    companyId: group.companyId,
            },{
                $set:{
                    isSyncingUsers: true,
                }
            })
            //removing users with only all-users-tpir group and currentGroup
            await db.User.deleteMany({
                groups: { $all: [allUsersGroup._id, group._id], $size: 2 },
                companyId
            },);
            //removing current group only from  users which have multiple different groups too
            await db.User.updateMany(
                {
                    groups: { $all: [allUsersGroup._id, group._id] },
                    $expr: { $gt: [{ $size: "$groups" }, 2] }, // Size > 2
                },
                {
                    $pull: { groups: group._id },
                }
            );
            

            if (groupTPIR) {
                queue.create('retry-syncing-users',{
                    localGroupId:groupTPIR._id,
                    localCompanyId:group.companyId,
                    tacIdentityKey: group.tacIdentityKey,
                    tacCompanyId:company.tacCompanyId,
                    memberCount:group.apiUserCount,
                    licenseKey: company.tacLicenseKey,
                    lastSyncId: group.lastSyncId
                }).removeOnComplete(true).save();
            }
        }

        res.status(200).json({
            success: true,
            message: "Syncing started successfully!"
        });
    } catch (err) {
        console.error(err);
        next(err);
    }
};

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, syncGroupUsers);
export default apiRouter;
