import express from 'express';
import { randomString } from '../../functions';
import mailer from '../../mailer';
import crypto from '../../crypto';
import bcrypt from 'bcryptjs';
import config from '../../config'
import packageHelper from '../../service/package-helper';


let controller = async (req, res, next) => {
    try{
        const {endDate, emailUsersCount, whatsappUsersCount, domainCount, company, users, packageDetails} = req.body
    
        const licenseKey= req?.headers?.authorization?.split(' ')[1] ?? null;
        console.log({licenseKey})

        let isCompanyExist = await db.Company.findOne({tacLicenseKey: licenseKey, deletedAt:null})
        console.log({isCompanyExist})
        if(!isCompanyExist) {
            const { firstName, lastName, User } = req.body.users;

            const isAdminExist = await db.Admin.findOne({email: User?.email, deletedAt: null})
            if(isAdminExist) {
                await db.Admin.updateOne({email: User?.email, deletedAt: null},{$set:{tacIdentityKey: User?.IdentityKey}})
                throw new RequestError(`Admin with ${isAdminExist.email} already exists!`)
            }

            isCompanyExist = await db.Company.create({
                name: company.companyName, tacLicenseKey: licenseKey, alias: company?.alias,
                tacCompanyId: company.id, isTacEnabled: true, isNewCompany: true, industry: company?.industry, country: company?.country
            })

            const metaData = {
                tsatUrl: `${config.app.tsatUrl}`,
                isTsat: "false",
                mailSmtp: false,
            }

            for (let key in metaData) {
                const update = await db.MetaData.findOneAndUpdate({
                    companyId: isCompanyExist._id,
                    name: key,
                },{
                    value: metaData[key]
                },
                { upsert: true, new: true, setDefaultsOnInsert: true })
                console.log({update, key})
            }
            
            await db.Group.create({
                groupName: "all-users-tpir",
                type:"Custom",
                isDefaultGroup: true,
                emailAccess: false,
                messengerAccess: false,
                companyId: isCompanyExist._id,
                createdAt: new Date('9999-12-31')
            })
            
            let passwordHash;
            if (User?.meta) { 
                const decryptedPassword = crypto.decrypt(User.meta, config.adminCentral.crypto_secret);
                if (!decryptedPassword) {
                    throw new RequestError('Request from invalid source, meta decryption failed.', 409);
                }
                console.log({aaaa:decryptedPassword})
                passwordHash = bcrypt.hashSync(decryptedPassword);
            }
            
            console.log({isCompanyExist})
            const admin = await db.Admin.create({
                firstName: firstName, lastName: lastName, email: User?.email, password: passwordHash, isActive: true, isVerify: true,
                companyId: isCompanyExist._id, verfKey: randomString(10), verfKeyExpiry: new Date(), tacIdentityKey: User?.IdentityKey
            })
            
            const setPackage = await packageHelper.setPackageDetails(isCompanyExist, packageDetails)
        }

        await db.Company.updateOne({tacLicenseKey: licenseKey},{
            $set:{
                packageAccessKey: packageDetails?.packageAccessKey,
                alias: company?.alias
            }
        })

        const licenseFormat = {
            expiredAt: endDate,
            userLimit: emailUsersCount,
            userLimitMessenger: whatsappUsersCount,
            domainLimit: domainCount            
        }


        for (let key in licenseFormat) {
            const update = await db.MetaData.findOneAndUpdate({
                companyId: isCompanyExist._id,
                name: key,
            },{
                value: licenseFormat[key]
            },
            { upsert: true, new: true, setDefaultsOnInsert: true })
            console.log({update, key})
        }

        const setPackage = await packageHelper.setPackageDetails(isCompanyExist, packageDetails)


        return res.status(200).json({
            messages: "License updated successfully"
        })
    }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);

        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';

        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').post(controller);
export default apiRouter;