import express from 'express';
import packageHelper from '../../service/package-helper';


let controller = async (req, res, next) => {
    try{
        const { packageDetails } = req.body

        const company = await db.Company.findOne({packageAccessKey: packageDetails.packageAccessKey, deletedAt: null})
        if(!company) throw new RequestError('Company not found!', 404);

        const syncPackage = await packageHelper.setPackageDetails(company, packageDetails)
        await db.Company.updateOne({_id: company._id},{$set: {packageModifiedLocally: true}})
        
        return res.status(200).json({
            success: true,
            message: "Package updated successfully",
        })
        
    }catch(error){
    const statusCode = error.status || 500;
      const isClientError = statusCode >= 400 && statusCode < 500;
      console.error('API Error:', error);

      const responseMessage = isClientError
          ? error.message || 'The request could not be processed.'
          : 'An internal server error occurred.';

      res.status(statusCode).json({
          success: false,
          message: responseMessage,
          error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
      });
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').post(controller);
export default apiRouter;