import express from 'express';
import crypto from '../../crypto';
import bcrypt from 'bcryptjs';
import config from '../../config'


let controller = async (req, res, next) => {
    try{
        const {email, meta} = req.body
    
        const api_key= req?.headers?.authorization?.split(' ')[1] ?? null;
        
        if (api_key !== config.adminCentral.api_key || !api_key) {
            throw new RequestError('Unauthorized User', 401);
        }

        let passwordHash;
        if (meta) { 
            const decryptedPassword = crypto.decrypt(meta, config.adminCentral.crypto_secret);
            if (!decryptedPassword) {
                throw new RequestError('Request from invalid source, meta decryption failed.', 409);
            }
            passwordHash = bcrypt.hashSync(decryptedPassword);

            const admin = await db.Admin.findOne({email, deletedAt: null})
            if(admin){
                await db.Admin.updateOne({email},{$set:{ password: passwordHash }})
            }
    
            const employee = await db.Employee.findOne({email, deletedAt: null})
            if(employee){
                await db.Employee.updateOne({email},{$set:{ password: passwordHash }})
            }
        }


        return res.status(200).json({
            messages: meta ? "Password updated successfully" : "Meta not recieved, password not updated!"
        })
    }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);

        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';

        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').post(controller);
export default apiRouter;