import express from 'express';
import {syncDomainsFromTa} from '../../service/syncDomains'
import { jwtStrategy } from '../../middlewares/strategy'

let controller = async (req, res, next) => {
    try {
        
        let company = await db.Company.findOne({
            _id: req.user.companyId
        })
        
        if(!company) throw new RequestError("Company not found",404)
        let syncDomains = await syncDomainsFromTa(company._id)        

        return res.status(200).json({
            success: true,
            message: "Domains fetched from Threatcop Admin and Created Successfully"
        })

    } catch (error) {
        console.log("The error inside sync identity keys: ", error);
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error?.response?.data);

        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';

        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
    }
};

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy ,controller);
export default apiRouter;
