import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy'
import axios from 'axios';
import config from '../../config';

let controller = async (req, res, next) => {
    try{
        const { companyId } = req.user

        const company = await db.Company.findOne({_id: companyId, deletedAt: null})
        if(!company) throw new RequestError("Company not found",404)

        let response =await axios.get(`${process.env.TAC_URL}/api/sync-services/common/fetch-group-user-count`,
        {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${company.tacLicenseKey}`
            },
            ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
        }
        )

        return res.status(200).send({
            success: true
        })
      }catch(error){
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);
  
        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';
  
        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( jwtStrategy, controller);
export default apiRouter;