import express from 'express';
import config from '../../config';
import { queue } from '../../kue';

let controller = async (req, res, next) => {
    try {
        const api_key = req?.headers?.authorization?.split(' ')[1] ?? null;
            if (!api_key || api_key !== config.adminCentral.api_key) {
                throw new RequestError('UnAuthorized User', 401);
            }
            let { companyId, group } = req.body;
            let tacCompanyId = companyId;

            let company =  await db.Company.findOne({ tacCompanyId });

            if(!company) throw new RequestError("Invalid CompanyId", 400);

            let localCompanyId = company._id;
        
            for(let i=0; i<group.length; i++){
                let g = group[i]
                let {groupId, IdentityKey: groupIdentityKey, memberCount, groupName} = g;
                    await db.Group.updateOne({
                        _id: groupId, localCompanyId
                    },{
                        $set:{
                            tacIdentityKey: groupIdentityKey,
                            groupName,
                            lastSyncId: null,
                            lastSyncIdMismatch: false,
                        }
                    })
        
                // Main processing loop
                let offset = 0;
                const BATCH_LIMIT = 1000; // Process 1000 records at a time
        
                while (offset <= memberCount) {
                    // Calculate the actual limit for this batch
                    const currentLimit = Math.min(BATCH_LIMIT, memberCount - offset);
        
                    console.log({
                        offset,
                        BATCH_LIMIT,
                        memberCount,
                        i,
                        gLength: group.length-1,
                        check: (offset + BATCH_LIMIT >= memberCount && i == group.length-1) 
                    })
                    // Create queue job for processing this batch
                    queue.create('sync-tac-users-identityKey', {
                        tacCompanyId,
                        groupIdentityKey,
                        appName: "TPIR",
                        limit: currentLimit,
                        offset,
                        isLastBatch: (offset + BATCH_LIMIT >= memberCount && i == group.length-1),
                        companyId: localCompanyId
                    }).removeOnComplete(true).save();
        
                    // Increment offset for next batch
                    offset += BATCH_LIMIT;
                }

            }
            if(group.length == 0){
                await db.Company.updateOne({
                    _id: localCompanyId
                },{
                    $set:{
                        isTacEnabled: true,
                        isTaConnectionInProgess: false
                    }
                })
            }

            return res.status(200).json({
                success: true,
                message: `Groups and its user's IdentityKey sync jobs created successfully`
            });

    } catch (error) {
        console.log("The error inside sync identity keys: ", error);
        const statusCode = error.status || 500;
        const isClientError = statusCode >= 400 && statusCode < 500;
        console.error('API Error:', error);

        const responseMessage = isClientError
            ? error.message || 'The request could not be processed.'
            : 'An internal server error occurred.';

        res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
        });
    }
};

const apiRouter = express.Router();
apiRouter.route('/').post(controller);
export default apiRouter;
