import express from 'express';
import config from '../../config'
import { queue } from '../../kue';


let controller = async (req, res, next) => {
    try {
        const api_key = req?.headers?.authorization?.split(' ')[1] ?? null;
            if (!api_key || api_key !== config.adminCentral.api_key) {
                throw new RequestError('Unauthorized User', 401);
            }
    
            let { userId, roleId, companyId } = req.body;
            if (!userId || !roleId || !companyId) {
                throw new RequestError('Invalid Request: Missing Parameters', 400);
            }

            const employee = await db.Employee.findOne({_id: userId, companyId, deletedAt: null})
            if(!employee) throw new RequestError("Employee not found!")
            
            const employeeRoles = await db.EmployeeRole.findOne({companyId, employeeId: userId, deletedAt: null})
            if(!employeeRoles){
                await db.EmployeeRole.create({roleIds: [roleId], employeeId: userId, companyId})
            }
            else{
                await db.EmployeeRole.updateOne({companyId, employeeId: userId, deletedAt: null},{$set:{
                    roleIds: [roleId]
                }})
            }
    
            return res.status(200).json({ success: true, message: "IAM updated successfully." });
      } catch (error) {
          const statusCode = error.status || 500;
          const isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', error);

          const responseMessage = isClientError
              ? error.message || 'The request could not be processed.'
              : 'An internal server error occurred.';

          res.status(statusCode).json({
              success: false,
              message: responseMessage,
              error: isClientError ? { code: error.code || 'UNEXPECTED_ERROR', description: error.description || null } : undefined,
          });
      }
    }
const apiRouter = express.Router();
apiRouter.route('/').post(controller);
export default apiRouter;