import express from 'express';
import config from '../../config'
import { queue } from '../../kue';

let controller = async (req, res, next) => {
    try {
        const { api_key, firstName, lastName, localCompanyId, phoneNumber, identityKey, email } = req.body;
        if (api_key !== config.adminCentral.api_key) throw new RequestError('Unauthorized User', 401);

        const name = lastName ? `${firstName} ${lastName}` : firstName;

        let user = await db.User.findOne({
            tacIdentityKey: identityKey,
            companyId: localCompanyId
        });

        console.log("djbajdsbjadb",user)

        if (user) {
            await db.User.updateOne(
                { email: user.email, companyId: localCompanyId }, 
                {
                    $set: {
                        name,
                        tacIdentityKey: identityKey,
                        phoneNumber
                    }
                }
            );
        } 
        
        let employee = await db.Employee.findOne({tacIdentityKey: identityKey, companyId: localCompanyId})
        console.log({employee})
        if(employee){
            await db.Employee.updateOne({tacIdentityKey: identityKey, companyId: localCompanyId},{ $set:{
                firstName, lastName, tacIdentityKey: identityKey
            }})
        }

        let admin = await db.Admin.findOne({tacIdentityKey: identityKey, companyId: localCompanyId})
        console.log({admin})
        if(admin){
            await db.Admin.updateOne({tacIdentityKey: identityKey, companyId: localCompanyId},{ $set:{
                firstName, lastName, tacIdentityKey: identityKey
            }})
        }

        res.status(200).json({
            "success" : true,
            "message" : "User updated successfully",
        })
    } catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;

            // Log the error internally
            console.error('API Error:', error);

            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";

            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( /*jwtStrategy, permission('IAM','Read'),*/ controller);
export default apiRouter;