import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy'; 
import axios from 'axios'; 

let controller = async (req, res, next) => {
    const { connectionStatus } = req.body;

    try {
        const company = await db.Company.findById(req.user.companyId);

        if(company?.isTaConnectionInProgess) throw new RequestError("Integration with TA is in progress. Please Wait!")

        if (!connectionStatus) {
            const individualUserGroup = await db.Group.findOne({
                groupName: "Individual-Users",
                type: "Admin",
                companyId: company?._id,
                deletedAt: null
            }) 

            await db.Group.updateMany(
                { companyId: company._id, type: "Custom", deletedAt: null },
                { $set: { type: "Admin" } }
            );

            if(individualUserGroup){
                await db.User.updateMany({companyId: company._id},
                    {
                        $pull: { groups: individualUserGroup._id },  
                    }
                )
    
                await db.Group.deleteOne({_id:individualUserGroup._id, companyId: company._id})
            }

        }
        else{
            const activeUsersGroup = await db.Group.findOne({
                groupName: 'Active Users',
                type: 'Admin',
                companyId: company._id,
                deletedAt: null
            });

            const individualUserGroup = await db.Group.create({
                groupName: 'Individual-Users',
                companyId: company._id,
                type:"Admin"
            });
            
            const allUsersGroup = await db.Group.findOne({
                groupName: 'all-users-tpir',
                type: 'Admin',
                isDefaultGroup: true,
                companyId: company._id,
                deletedAt: null
            });
            console.log({ allUsersGroup });
            
            
            await db.Group.updateOne(
                { _id: allUsersGroup._id },
                { $set: { type: "Custom" } }
            );

            await db.User.updateMany({
                groups: { $all: [allUsersGroup._id], $size: 1 },
                companyId: company._id
            },{ 
                $addToSet: { groups: individualUserGroup._id } 
            });
            
        }

        await axios.post(
            `${process.env.TAC_URL}/api/sync-services/common/admin-central-connect`,
            { connectionStatus },
            { 
                headers: { 
                    Authorization: `Bearer ${company.tacLicenseKey}` 
                },
                ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            }
        );

        const updateFields = connectionStatus
            ? { isTaConnectionInProgess: true, isTacEnabled: false }
            : { isTacEnabled: false, isTaConnectionInProgess: false };

        await db.Company.updateOne({ _id: company._id }, { $set: updateFields });

        console.log("Operation completed successfully.");

        return res.status(200).json({
            success: true,
            message: connectionStatus ? "Connecting Threatcop Admin":"Threatcop Admin Disconnected Successfully",
            connectionStatus
        })
            
        } 
    catch (error) {        
        const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
            const isClientError = statusCode >= 400 && statusCode < 500;

            // Log the error internally
            console.error('API Error:', error);

            // Respond with a generic error message for server errors to avoid exposing details
            const responseMessage = isClientError ? 
                (error.message || "The request could not be processed.") : 
                "An internal server error occurred.";

            res.status(statusCode).json({
                success: false,
                message: responseMessage,
                // Include more specific error details only if it's safe to expose them
                error: isClientError ? {
                    code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                    description: error.description || null // Optional additional info
                } : undefined
            });
        }
    }
const apiRouter = express.Router();
apiRouter.route('/').post( jwtStrategy, controller);
export default apiRouter;
