import express from 'express';
import Joi from 'joi';
import { jwtStrategy } from '../../middlewares/strategy';
import restrictFeature from '../../middlewares/featureBlocker';
import { permission } from '../../middlewares/permission';
import { validateBody } from '../../middlewares/validator';

const validator = Joi.object().keys({
    advanceSearchEmailId: Joi.string().hex().length(24).required()
});

const controller = async (req, res, next) => {
    try {
        const { advanceSearchEmailId } = req.body;
        if (!advanceSearchEmailId) {
            return res.status(400).send({ success: false, messages: ['advanceSearchEmailId is required'] });
        }
        let email;
        try {
            email = await db.AdvanceSearchEmail.findOne({
                _id: advanceSearchEmailId,
                deletedAt: null
            }, { body: 1, subject: 1, mailRecievedTime: 1, to: 1, messageId: 1, domainId: 1, isTrashed: 1 });
        } catch (dbError) {
            return res.status(500).send({ success: false, messages: ['Database error'], error: dbError.message });
        }
        if (!email) {
            return res.status(404).send({ success: false, messages: ['Email not found'] });
        }
        return res.status(200).send({
            success: true,
            body: email.body,
            subject: email.subject,
            mailRecievedTime: email.mailRecievedTime,
            to: email.to,
            messageId: email.messageId,
            domainId: email.domainId,
            isTrashed: email.isTrashed
        });
    } catch (error) {
        console.error('API error:', error);
        return res.status(500).send({ success: false, messages: ['Internal server error'], error: error.message });
    }
};

const apiRouter = express.Router();
apiRouter.route('/').post(
    jwtStrategy,
    restrictFeature('TPIR-ADVS'),
    permission('AdvancedSearch', 'Read'),
    validateBody(validator),
    controller
);

export default apiRouter;
