import Joi from 'joi';
import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';

const validator = Joi.object().keys({
    page: Joi.number().min(0).required(),
    limit: Joi.number().min(1).required()
});

/**
 * @api {post} /api/v1/hack-record/get get
 * @apiName get-hackrecord
 * @apiGroup Hack Record
 * @apiDescription Get hack records
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  email   Required Email whose hack records are to be fetched 
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  message    []
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "results": "[]"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    results    []
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "Request failed with status code 500"
 *          ]
 *      }
 */

let controller = async (req, res, next) => {
    const companyId = req.user.companyId;
    const { page = 1, limit = 10 } = req.query;
    let count = await db.AuditLog.countDocuments({ companyId });
    let results = await db.AuditLog.find({ companyId })
    .sort({'createdAt': -1})
    .skip((page-1)*limit)
    .limit(limit)
    return res.status(200).send({ Success: true, results, count })
}

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, validateBody(validator), controller);
export default apiRouter;