import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';


const controller = async (req, res, next) => {
    try {
        const { tenant } = req.query;

        if (tenant) {
            console.log(`Admin consent granted for tenant: ${tenant}`);
            // Save tenantId for future API calls
            res.send("Admin consent granted! You can close this page.");
        } else {
            res.status(400).send("Admin consent failed.");
        } 
       
    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(controller);
export default apiRouter;