import Joi from 'joi';
import express from 'express';
import { sanitize } from '../../middlewares/sanitizer';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import { queue } from '../../kue'
import restrictFeature from '../../middlewares/featureBlocker';

const validator = Joi.object().keys({
  mailIds: Joi.array().required(),
});


const controller = async (req, res, next) => {
  try {
    const { mailIds } = req.body;
    const companyId = req.user.companyId;

    try {
      let isAlreadyBroadcasted 
      if (mailIds.length==1){
      const singleMailId = mailIds[0];
      const MailAlreadySent = await db.ReportedMail.findOne({ _id:singleMailId });
      isAlreadyBroadcasted = MailAlreadySent.isBroadcastMail;
    }
    
      mailIds.map((id)=>{ queue.create('broadcast-reported-mails', {mailIds: [id], companyId}).removeOnComplete(true).priority('high').save() })
      res.status(200).send({isAlreadyBroadcasted, message: 'Broadcast emails sent successfully.' });
    } catch (error) {
      console.error(`Error in sending broadcast emails: ${error}`);
      res.status(500).send({ error: 'Internal server error' });
    }

  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), validateBody(validator), jwtStrategy, checkCompanyValidityStrategy, restrictFeature("TPIR-EB"), permission('Emails', 'Read'), controller);
export default apiRouter;






