import Joi from 'joi';
import express from 'express';

import { checkTaConnectionStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';

const validator = Joi.object().keys({
    domainId: Joi.string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/domain/domain-delete?domainId=63b676c744ed3b8a72386597 domain-delete
 * @apiName domain-delete
 * @apiGroup Domains
 * @apiDescription Delete a domain
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}  domainId   id of the domain
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  message    Credentials deleted successfully.
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "message": "Credentials deleted successfully."
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages   Invalid domain recieved
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *                "Invalid domain recieved"
 *           ]
 *       }
 */


let controller = async (req, res, next) => {
    try{
        const domainId = req.query;
        const companyId = req.user.companyId;
        let domain = await db.Domain.findOne({
            _id: domainId, companyId, deletedAt: null 
        })
        if(!domain){
            throw new RequestError('Invalid domain recieved');
        }
        await db.Domain.findOneAndUpdate({ 
            _id: domainId, companyId
        }, {
            isCredential: false
        });
        return res.status(200).send({ success: true, message: 'Credentials deleted successfully.' })
    } catch (error) {
        console.log('error', error);
        next(new RequestError(error))
    }
}

const apiRouter = express.Router();
apiRouter.route('/').delete(jwtStrategy, checkTaConnectionStrategy, validateBody(validator), controller);
export default apiRouter;