import Joi from 'joi';
import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';
import { validateBody } from '../../middlewares/validator';
import crypto from '../../crypto.js';

const validator = Joi.object().keys({
    domainId: Joi.string().hex().length(24).required()
});

const controller = async (req, res, next) => {
    try {
        const { domainId } = req.query
        const companyId = req.user.companyId;

        let domain = await db.Domain.findOne({
            _id: domainId,
            companyId,
            deletedAt: null
        })

        // Build a single credential object with decrypted values (masked secret) – no nesting
        let credential = null;
        if (domain && domain.credential && domain.credential.integrationType) {
            const integrationType = domain.credential.integrationType;
            credential = { integrationType };
            if (integrationType === 'Manual') {
                if (domain.credential.clientId) {
                    credential.clientId = crypto.decrypt(domain.credential.clientId);
                }
                if (domain.credential.tenantId) {
                    credential.tenantId = crypto.decrypt(domain.credential.tenantId);
                }
                if (domain.credential.clientSecret) {
                    const decryptedSecret = crypto.decrypt(domain.credential.clientSecret);
                    credential.clientSecret =
                        decryptedSecret && decryptedSecret.length > 5
                            ? decryptedSecret.slice(0, 5) + '*'.repeat(decryptedSecret.length - 5)
                            : '*'.repeat(decryptedSecret ? decryptedSecret.length : 0);
                }
            } else if (integrationType === 'Direct') {
                if (domain.credential.tenantId) {
                    credential.tenantId = crypto.decrypt(domain.credential.tenantId);
                }
            }
        }

        let subDomainGroups = await db.SubDomainGroup.find({ domainId: domain._id, companyId }, { _id: 0, groupName: 1 })

        domain = {
            ...domain.toObject(),
            credential,
            subDomainGroups: (subDomainGroups && subDomainGroups.length) ? subDomainGroups.map(group => group.groupName) : []
        }

        let groups = await db.UserGroup.find({ domainId: domain._id, companyId }, { label: 1, value: 1, _id: 0 })
        domain = { ...domain, groups }

        res.status(200).json({ success: true, domain });
    } catch (err) {
        console.log(err);
        next(err)
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, permission('Domain','Read'), validateBody(validator), controller);
export default apiRouter;