import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';

/**
 * @api {get} /api/v1/domain/domain-list domain-list
 * @apiName domain-list
 * @apiGroup Domains
 * @apiDescription Returns a list of all domains of a user's company without active and total users for dropdown in different pages
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {Array}   domains    list of all domains
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {    
 *         "success": true,
 *         "domains": [
 *             {
 *                 "_id": "63d0eaaa032f943fc31e4ea2",
 *                 "domainName": "kdmarc.com",
 *                 "txtRecord": "tab-site-verification=W7CIoMg0Bitq6hahLZ4pW8aL6h4I23DLTHV88cFj",
 *                 "isVerified": true,
 *                 "companyId": "63d0ea61032f943fc31e4e80",
 *                 "domainType": "Outlook",
 *                 "isCredential": true,
 *                 "isSyncingUser": false,
 *                 "deletedAt": null,
 *                 "createdAt": "2023-01-25T08:39:06.842Z",
 *                 "updatedAt": "2023-01-25T09:00:27.078Z",
 *                 "__v": 0,
 *                 "syncStartAt": "2023-01-25T09:00:25.226Z",
 *                 "syncEndAt": "2023-01-25T09:00:27.077Z",
 *             },
 *             {
 *                 "_id": "63d0f49e4b01a8cf9308bf00",
 *                 "domainName": "kratikal.com",
 *                 "txtRecord": "tab-site-verification=J6oFlCGhQzEWZKVgHqQGywiru4gslcxDgCBEWWrQ",
 *                 "isVerified": false,
 *                 "companyId": "63d0ea61032f943fc31e4e80",
 *                 "domainType": "Outlook",
 *                 "isCredential": false,
 *                 "isSyncingUser": false,
 *                 "deletedAt": null,
 *                 "createdAt": "2023-01-25T09:21:34.965Z",
 *                 "updatedAt": "2023-01-25T09:21:34.965Z",
 *                 "__v": 0,
 *             }
 *         ]
 *      }
 * 
 */

const controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;

        let domains = await db.Domain.find({
            companyId,
            deletedAt: null
        }).select('-credential');
       
        res.status(200).json({ success: true, domains });
    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, permission('Domain','Read'), controller);
export default apiRouter;