import express from 'express';
import axios from 'axios';
import Joi from 'joi';

import { jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';
import { validateBody } from '../../middlewares/validator';
import credentials from '../../service/credentials';
import { createSubscription } from '../../service/subscriptionService';

const validator = Joi.object().keys({
    domainId: Joi.string().hex().length(24).required(),
    email: Joi.string().email().required()
});


const controller = async (req, res, next) => {
    try {
        const { companyId } = req.user;
        const { domainId, email } = req.body;

        const subscriptionCreated = await createSubscription(companyId, domainId, email);

        if (!subscriptionCreated.success) {
            throw new RequestError(`Failed to configure reporting subscription.`);
        }

        await db.Domain.updateOne({ _id: domainId, companyId, deletedAt: null }, { webhookEmail: email, webhookAccessKey: `${companyId}-${domainId}-${email}` });

        return res.status(200).json({ success: true, message: "Reporting via client configured successfully!" });
    } catch (error) {
        next(error);
    }
};

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy, validateBody(validator), permission('Domain', 'Write'), controller);

export default apiRouter;
