import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy';

const controller = async (req, res, next) => {
    try {
        const { user } = req;
        if (!user) return next(new RequestError("User not found!"));

        const companyId = user.companyId;
        if (!companyId) return next(new RequestError("User is not associated with any company!"));

        const company = await db.Company.findOne({ _id: companyId }).lean();
        if (!company) return next(new RequestError("Company not found!"));

        let policies = [];

        if (user.type === "root") {
            policies = await db.Policy.find().select("name").lean();
            policies = policies.map(policy => policy.name);
        } else {
            const employeeRoles = await db.EmployeeRole.find({
                employeeId: user._id,
                companyId,
                deletedAt: null
            })
            .populate({
                path: 'roleIds',
                populate: {
                    path: 'policyIds',
                    select: 'name'
                }
            })
            .lean();

            policies = employeeRoles
                .flatMap(role => role.roleIds || []) 
                .flatMap(role => role.policyIds || []) 
                .map(policy => policy.name) 
                .filter(Boolean);
            console.log({policies})
            policies = [...new Set(policies)]; 
        }

        return res.status(200).json({ policies }); 

    } catch (error) {
        return next(error); 
    }
};

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, controller);

export default apiRouter;
